package gov.va.med.mhv.sm.webservice;

import gov.va.med.mhv.foundation.service.response.BaseServiceResponse;
import gov.va.med.mhv.foundation.service.response.BaseServiceResponseUtils;
import gov.va.med.mhv.foundation.service.response.messages.Message;
import gov.va.med.mhv.foundation.service.response.messages.MessageHandler;
import gov.va.med.mhv.foundation.util.Loggable;
import gov.va.med.mhv.foundation.util.Precondition;
import gov.va.med.mhv.sm.service.response.messages.SmExceptionMessageTranslator;

import javax.servlet.http.HttpServlet;

import org.apache.axis.MessageContext;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public abstract class AbstractBaseWebService implements Loggable {

	private static final Log LOG = LogFactory.getLog(AbstractBaseWebService.
		class);

	public Log getLog() {
		return LOG;
	}
	
	protected final Log log() {
		Log log = getLog();
		return (log != null) ? log : LOG;
	}
	
	/**
	 * Retrieves a bean with the given name from the application context 
	 * associated with the message context.
	 * @param beanName The name of the bean to get.
	 * @return The bean.
	 * @throws IllegalArgumentException When the application context cannot be 
	 * found or the bean does not exist in the application context 
	 */
    protected Object getBean(String beanName) {
    	return getBean(beanName, true);
    }
    
	/**
	 * Retrieves a bean with the given name from the application context
	 * associated with the message context.
	 * @param beanName The name of the bean to get.
	 * @param isRequired Indicates whether the bean must be found in the 
	 * application context.
	 * @return The bean
	 * @throws IllegalArgumentException When the application context cannot be 
	 * found or the bean does not exist in the application context and the
	 * bean is required. 
	 */
    protected Object getBean(String beanName, boolean isRequired) {
    	MessageContext messageContext = MessageContext.getCurrentContext();
    	Precondition.assertNotNull("messageContext", messageContext);
    	HttpServlet servlet = (HttpServlet) messageContext.getProperty(
    		HTTPConstants.MC_HTTP_SERVLET);
    	Precondition.assertNotNull("servlet", servlet);
    	WebApplicationContext applicationContext = WebApplicationContextUtils.
    		getWebApplicationContext(servlet.getServletContext());
    	Precondition.assertNotNull("applicationContext", applicationContext);
    	Object bean = applicationContext.getBean(beanName);
    	if (isRequired) {
    		Precondition.assertNotNull(applicationContext.getDisplayName() + 
    			"." + beanName, bean);
    	}
    	return bean;
    }

    protected boolean hasError(BaseServiceResponse response) {
    	return BaseServiceResponseUtils.hasError(response);
    }
    protected boolean hasError(BaseServiceResponse response, String key) {
    	return BaseServiceResponseUtils.hasError(response, key);
    }

    protected boolean hasInfo(BaseServiceResponse response) {
    	return BaseServiceResponseUtils.hasInfo(response);
    }
    protected boolean hasInfo(BaseServiceResponse response, String key) {
    	return BaseServiceResponseUtils.hasInfo(response, key);
    }

    protected String getErrorText(BaseServiceResponse response, 
    	MessageHandler handler) 
    {
   		return BaseServiceResponseUtils.getErrorText(response, handler);
    }

    protected String getInfoText(BaseServiceResponse response, 
    	MessageHandler handler) 
    {
   		return BaseServiceResponseUtils.getInfoText(response, handler);
    }

    protected boolean hasExceptionError(BaseServiceResponse response) {
    	return BaseServiceResponseUtils.hasError(response, 
    		SmExceptionMessageTranslator.EXCEPTION_ERRORS);
    }

}
